//Rotating gradientsMod01.fsh
//https://glslsandbox.com/e#78082.0
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
uniform sampler2D iChannel0;

/*
 * Original shader from: https://www.shadertoy.com/view/7l3SDX
 */

#ifdef GL_ES
precision mediump float;
#endif

// glslsandbox uniforms
uniform float time;
uniform vec2 mouse;
uniform vec2 resolution;

// shadertoy emulation
#define iTime time
#define iResolution u_WindowSize
#define time          u_Elapsed*0.31416
#define PI            3.141592654
#define mouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
const float pi = 3.14159;
// --------[ Original ShaderToy begins here ]---------- //
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
void main(void) 
{
     vec2 uv = gl_FragCoord.xy/iResolution.xy - 0.5;
    uv.x /= iResolution.y/iResolution.x;
    float d = length(uv) * 10.0;
    float i = floor(d);
    float n = 1.0;
    d = mod(d, n);
    float a = smoothstep(0.10, 0.15, d) - smoothstep(0.90, 0.95, d);
    float angle = atan(uv.y, uv.x) + i;
    float shade = 0.5 + 0.8 * smoothstep(0.10, 0.90, d);
    float off = (0.01 + n * 1.5);
    float aa = mod(angle * (2.0 + i) + n - iTime * off, 3.14159);
    float clip = smoothstep(0.10, 1.50, aa) - smoothstep(2.20, 2.25, aa);
    float glow = smoothstep(1.20, 2.20, aa) - smoothstep(2.20, 2.25, aa);
    
    gl_FragColor = vec4(
      (sin(angle + vec3(0.0, 1.2, 3.2) + iTime) * 0.5 * shade + 0.5) * a * clip + 
       a * glow * glow * 0.5, 1.0
    );
}
// --------[ Original ShaderToy ends here ]---------- //

//void main(void)
//{//
//    mainImage(gl_FragColor, gl_FragCoord.xy);
//}//